IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Filter_Bed_Unavailable]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Filter_Bed_Unavailable]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
--


-- =============================================
-- Author:		PII
-- Create date: 07.09.2011
-- Description:	List bed unavailable by vista code.
-- =============================================
CREATE PROCEDURE [dbo].[usp_Filter_Bed_Unavailable] 
	@DOMAIN_ID NVARCHAR(50),
	@VISTA_SITE_UID UNIQUEIDENTIFIER
AS
BEGIN
SET NOCOUNT ON
		
	SELECT
		[A].[CREATION_DATE],
		[BU].[BED_UID] AS [BED_UID],
		[BU].[IS_UNAVAILABLE_FROM_VISTA] AS IS_UNAVAILABLE_FROM_VISTA
	FROM ACT A
		INNER JOIN BED_UNAVAILABLE AS BU ON A.ID = BU.ACT_ID		
	WHERE [A].[DOMAIN_ID] = @DOMAIN_ID AND BU.VISTA_SITE_UID = @VISTA_SITE_UID AND [A].CANCELED_DATE IS NULL

END


GO


